/** @type {import("../def/formBuilds").FormList} */
export const DiamondForms =
{
    "temp_menu": {
        title: "Form Template Menu",
        body: "These buttons does different things",
        type: "action",
        elements: [
            {
                type: "button",
                buttonName: "Form 1",
                onClick: [
                    {type: "form", value: "temp_form1"}
                ]
            },
            {
                type: "button",
                buttonName: "Form 2",
                onClick: [
                    {type: "form", value: "temp_form2"}
                ]
            },
            {
                type: "button",
                buttonName: "Form 3",
                onClick: [
                    {type: "form", value: "temp_demo"}
                ]
            }
        ]
    },
    "temp_form1": {
        title: "Form 1 Title",
        body: "This is the Form 1 Body",
        type: "action", // Defaults to action if omitted
        elements: [
            {
                type: "button",
                buttonName: "Button 1",
                onClick: [
                    {
                        type: "form",
                        value: "temp_form2"
                    },
                    {
                        type: "sound",
                        value: "random.orb"
                    }
                ]
            }
        ]
    },
    "temp_form2": {
        title: "Form 2 Title",
        body: "This is the Form 2 Body",
        type: "action",
        onClose: [
            {
                type: "say",
                value: "Form 2 Closed"
            }
        ],
        elements: [
            {
                type: "button",
                buttonName: "Give Diamonds",
                icon: "textures/items/diamond",
                onClick: [
                    {
                        type: "give",
                        value: {
                            itemId: "minecraft:diamond",
                            amount: 64
                        }
                    }
                ]
            },
            {
                type: "button",
                buttonName: "Give Emeralds",
                icon: "textures/items/emerald",
                onClick: [
                    {
                        type: "cmds",
                        value: [
                            "give @s emerald 64",
                            "say Gave Emeralds"
                        ]
                    }
                ]
            }
        ]
    },
    "temp_demos": {
        title: "Temp Specials",
        body: "Temp special body",
        onOpen: [
            {
                type: "say",
                value: "Special Form Opened"
            }
        ],
        onClose: [
            {
                type: "say",
                value: "Special Form Closed"
            }
        ],
        elements: [
            {
                type: "button",
                buttonName: "JS Console Button",
                onClick: [
                    {
                        type: "eval",
                        value: "console.warn('Hello world', Math.PI)" // JS code in one line
                    }
                ]
            },
            {
                type: "button",
                buttonName: "Playing Sound Button",
                onClick: [
                    {
                        type: "sound",
                        value: "random.orb"
                    }
                ]
            },
            {
                type: "button",
                buttonName: "Tellraw Button",
                onClick: [
                    {
                        type: "tellraw",
                        value: {"rawtext":[{"text":"Player name: "},{"selector":"@s"},{"text":". Chicken in your language: "},{"translate":"entity.chicken.name"}]}
                    }
                ]
            },
            {
                type: "button",
                buttonName: "Give Owner Tag",
                onClick: [
                    {
                        type: "add_tag",
                        value: "Owner"
                    }
                ]
            },
            {
                type: "button",
                buttonName: "Remove Owner Tag",
                onClick: [
                    {
                        type: "remove_tag",
                        value: "Owner"
                    }
                ]
            }
        ]
    }
}